<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Lookups\V2;

use Twilio\Values;
abstract class QueryModels
{
    /**
     * @property string $firstName
     * @property string $lastName
     * @property string $addressLine1
     * @property string $addressLine2
     * @property string $city
     * @property string $state
     * @property string $postalCode
     * @property string $addressCountryCode
     * @property string $nationalId
     * @property string $dateOfBirth
    */
    public static function createIdentityMatchParameters(array $payload = []): IdentityMatchParameters
    {
        return new IdentityMatchParameters($payload);
    }

    /**
     * @property string $lastVerifiedDate
    */
    public static function createReassignedNumberParameters(array $payload = []): ReassignedNumberParameters
    {
        return new ReassignedNumberParameters($payload);
    }

    /**
     * @property string $partnerSubId
    */
    public static function createRiskParameters(array $payload = []): RiskParameters
    {
        return new RiskParameters($payload);
    }

    /**
     * @property string $correlationId Unique identifier used to match request with response
     * @property string $phoneNumber
     * @property string[][] $fields
     * @property string $countryCode
     * @property IdentityMatchParameters $identityMatch
     * @property ReassignedNumberParameters $reassignedNumber
     * @property RiskParameters $smsPumpingRisk
    */
    public static function createLookupBatchRequest(array $payload = []): LookupBatchRequest
    {
        return new LookupBatchRequest($payload);
    }

    /**
     * @property LookupBatchRequest[] $phoneNumbers
    */
    public static function createLookupRequest(array $payload = []): LookupRequest
    {
        return new LookupRequest($payload);
    }

}

class IdentityMatchParameters implements \JsonSerializable
{
    /**
     * @property string $firstName
     * @property string $lastName
     * @property string $addressLine1
     * @property string $addressLine2
     * @property string $city
     * @property string $state
     * @property string $postalCode
     * @property string $addressCountryCode
     * @property string $nationalId
     * @property string $dateOfBirth
    */
        protected $firstName;
        protected $lastName;
        protected $addressLine1;
        protected $addressLine2;
        protected $city;
        protected $state;
        protected $postalCode;
        protected $addressCountryCode;
        protected $nationalId;
        protected $dateOfBirth;
    public function __construct(array $payload = []) {
        $this->firstName = Values::array_get($payload, 'first_name');
        $this->lastName = Values::array_get($payload, 'last_name');
        $this->addressLine1 = Values::array_get($payload, 'address_line1');
        $this->addressLine2 = Values::array_get($payload, 'address_line2');
        $this->city = Values::array_get($payload, 'city');
        $this->state = Values::array_get($payload, 'state');
        $this->postalCode = Values::array_get($payload, 'postal_code');
        $this->addressCountryCode = Values::array_get($payload, 'address_country_code');
        $this->nationalId = Values::array_get($payload, 'national_id');
        $this->dateOfBirth = Values::array_get($payload, 'date_of_birth');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
        ];
        if (isset($this->firstName)) {
            $jsonString['first_name'] = $this->firstName;
        }
        if (isset($this->lastName)) {
            $jsonString['last_name'] = $this->lastName;
        }
        if (isset($this->addressLine1)) {
            $jsonString['address_line1'] = $this->addressLine1;
        }
        if (isset($this->addressLine2)) {
            $jsonString['address_line2'] = $this->addressLine2;
        }
        if (isset($this->city)) {
            $jsonString['city'] = $this->city;
        }
        if (isset($this->state)) {
            $jsonString['state'] = $this->state;
        }
        if (isset($this->postalCode)) {
            $jsonString['postal_code'] = $this->postalCode;
        }
        if (isset($this->addressCountryCode)) {
            $jsonString['address_country_code'] = $this->addressCountryCode;
        }
        if (isset($this->nationalId)) {
            $jsonString['national_id'] = $this->nationalId;
        }
        if (isset($this->dateOfBirth)) {
            $jsonString['date_of_birth'] = $this->dateOfBirth;
        }
        return $jsonString;
    }
}

class ReassignedNumberParameters implements \JsonSerializable
{
    /**
     * @property string $lastVerifiedDate
    */
        protected $lastVerifiedDate;
    public function __construct(array $payload = []) {
        $this->lastVerifiedDate = Values::array_get($payload, 'last_verified_date');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
        ];
        if (isset($this->lastVerifiedDate)) {
            $jsonString['last_verified_date'] = $this->lastVerifiedDate;
        }
        return $jsonString;
    }
}

class RiskParameters implements \JsonSerializable
{
    /**
     * @property string $partnerSubId
    */
        protected $partnerSubId;
    public function __construct(array $payload = []) {
        $this->partnerSubId = Values::array_get($payload, 'partner_sub_id');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
        ];
        if (isset($this->partnerSubId)) {
            $jsonString['partner_sub_id'] = $this->partnerSubId;
        }
        return $jsonString;
    }
}

class LookupBatchRequest implements \JsonSerializable
{
    /**
     * @property string $correlationId Unique identifier used to match request with response
     * @property string $phoneNumber
     * @property string[][] $fields
     * @property string $countryCode
     * @property IdentityMatchParameters $identityMatch
     * @property ReassignedNumberParameters $reassignedNumber
     * @property RiskParameters $smsPumpingRisk
    */
        protected $correlationId;
        protected $phoneNumber;
        protected $fields;
        protected $countryCode;
        protected $identityMatch;
        protected $reassignedNumber;
        protected $smsPumpingRisk;
    public function __construct(array $payload = []) {
        $this->correlationId = Values::array_get($payload, 'correlation_id');
        $this->phoneNumber = Values::array_get($payload, 'phone_number');
        $this->fields = Values::array_get($payload, 'fields');
        $this->countryCode = Values::array_get($payload, 'country_code');
        $this->identityMatch = Values::array_get($payload, 'identity_match');
        $this->reassignedNumber = Values::array_get($payload, 'reassigned_number');
        $this->smsPumpingRisk = Values::array_get($payload, 'sms_pumping_risk');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'phone_number' => $this->phoneNumber
        ];
        if (isset($this->correlationId)) {
            $jsonString['correlation_id'] = $this->correlationId;
        }
        if (isset($this->fields)) {
            $jsonString['fields'] = $this->fields;
        }
        if (isset($this->countryCode)) {
            $jsonString['country_code'] = $this->countryCode;
        }
        if (isset($this->identityMatch)) {
            $jsonString['identity_match'] = $this->identityMatch;
        }
        if (isset($this->reassignedNumber)) {
            $jsonString['reassigned_number'] = $this->reassignedNumber;
        }
        if (isset($this->smsPumpingRisk)) {
            $jsonString['sms_pumping_risk'] = $this->smsPumpingRisk;
        }
        return $jsonString;
    }
}

class LookupRequest implements \JsonSerializable
{
    /**
     * @property LookupBatchRequest[] $phoneNumbers
    */
        protected $phoneNumbers;
    public function __construct(array $payload = []) {
        $this->phoneNumbers = Values::array_get($payload, 'phone_numbers');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
        ];
        if (isset($this->phoneNumbers)) {
            $jsonString['phone_numbers'] = $this->phoneNumbers;
        }
        return $jsonString;
    }
}

