<?php

return [
    'permissions' => [
        'adminMultiShop' => [
            'shop' => ['index', 'create', 'edit', 'status.toggle', 'show', 'orders', 'products', 'reset.password'],
            'product' => ['index', 'approve', 'show', 'destroy'],
            'coupon' => ['index', 'create', 'edit', 'destroy'],
            'withdraw' => ['index', 'update', 'show'],
            'subscription-plan' => ['index', 'create', 'edit', 'toggle', 'destroy'],
        ],
        'admin' => [
            'dashboard' => ['index', 'notification'],
            'banner' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'ad' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'order' => ['index', 'show', 'status.change', 'payment.status.toggle', 'assign.rider'],
            'review' => ['index', 'toggle'],
            'brand' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'category' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'categoryAttribute' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'flashSale' => ['index', 'create', 'edit', 'destroy', 'toggle'],
            'product' => ['index', 'show'],
            'generale-setting' => ['index', 'update'],
            'business-setting' => ['index', 'update'],
            'verification' => ['index', 'update'],
            'socialLink' => ['index', 'update', 'toggle'],
            'socialAuth' => ['index', 'update', 'toggle'],
            'menu' => ['index', 'create', 'edit', 'remove', 'destroy'],
            'page' => ['index', 'create', 'edit', 'show', 'destroy', 'generate.AI.data'],
            'country' => ['index', 'create', 'edit', 'destroy'],
            'currency' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'themeColor' => ['index', 'update', 'change'],
            'deliveryCharge' => ['index', 'create', 'edit', 'destroy'],
            'pusher' => ['index', 'update'],
            'mailConfig' => ['index', 'update'],
            'paymentGateway' => ['index', 'update', 'toggle'],
            'sms-gateway' => ['index', 'update'],
            'googleReCaptcha' => ['index', 'update'],
            'contactUs' => ['index', 'update'],
            'firebase' => ['index', 'update'],
            'profile' => ['index', 'update', 'change-password'],
            'rider' => ['index', 'create', 'show', 'edit', 'destroy', 'toggle', 'assign.order'],
            'customer' => ['index', 'create', 'show', 'edit', 'destroy', 'toggle', 'reset.password'],
            'customerNotification' => ['index', 'send'],
            'language' => ['index', 'create', 'edit', 'destroy', 'export', 'import'],
            'employee' => ['index', 'create', 'edit', 'destroy', 'toggle', 'reset.password', 'permission', 'permission.update'],
            'role' => ['index', 'create', 'edit', 'destroy', 'permission', 'permission.update'],
            'ticketIssueType' => ['index', 'create', 'edit', 'toggle', 'delete'],
            'supportTicket' => ['index', 'show', 'setScheduled', 'sendMessage', 'updateStatus', 'pinMessage', 'chatToggle'],
            'support' => ['index', 'destroy'],
            'vatTax' => ['index', 'order.update', 'store', 'update', 'toggle', 'destroy'],
            'blog' => ['index', 'create', 'edit', 'toggle', 'destroy', 'generate.AI.data'],
            'offerBanner' => ['index', 'edit', 'update'],
            'aiPrompt' => ['index', 'configure', 'configure.update', 'update'],
            'whatsAppChat' => ['index', 'sendMessage', 'messageShow'],
            'unisharp.lfm' => ['show', 'upload', 'getDelete', 'getDownload', 'getCrop', 'getCropImage', 'getNewCropImage', 'getResize', 'performResize', 'performResizeNew', 'getRename', 'getAddfolder', 'getErrors', 'getFolders', 'getItems',]
        ],
        'shop' => [
            'order' => ['index', 'show', 'status.change','attach.barcode','fetch.products'],
            'product' => ['index', 'create', 'show', 'edit', 'toggle', 'destroy', 'barcode', 'generate.AI.data'],
            'flashSale' => ['index', 'show', 'productStore', 'productRemove', 'product.edit'],
            'voucher' => ['index', 'create', 'edit', 'toggle', 'destroy'],
            'bulk-product-import' => ['index', 'store'],
            'bulk-product-export' => ['index', 'demo', 'export'],
            'gallery' => ['index', 'store'],
            'pos' => ['index', 'sales', 'draft','addOrUpdateSKU'],
            'customer.chat' => ['index', 'getUsers', 'getMessage', 'sendMessage'],
            'employee' => ['index', 'create', 'edit', 'destroy', 'toggle', 'reset.password', 'permission', 'permission.update'],
            'profile' => ['index', 'edit', 'change-password'],
            'supplier' => ['index', 'create', 'store', 'show', 'edit', 'update', 'destroy', 'toggle', 'statistic', 'payment'],
            'purchase' => ['index', 'create', 'store', 'show', 'edit', 'update', 'destroy', 'attach.product', 'products', 'makeReceived', 'product.delete.barcode', 'invoice.search', 'invoice.add', 'summary', 'purchaseInvoice', 'summary','allProduct.stockSummary'],
            'purchaseReturn' => ['index', 'create', 'store', 'show', 'invoice.search', 'Invoice', 'invoice.add'],
        ],

        'shopMultiShop' => [
            'dashboard' => ['index', 'notification'],
            'subscription' => ['index', 'purchase', 'renew', 'switch', 'cancel'],
            'brand' => ['index'],
            'category' => ['index'],
            'withdraw' => ['index', 'store', 'show'],
        ],

    ],

    // only for human readable permissions names
    'customerReadableNames' => [
        'index' => 'list',
        'destroy' => 'delete',
        'toggle' => 'enable/disable',
        'status.toggle' => 'enable/disable',
        'reset.password' => 'reset password',
        'show' => 'view details',
        'permission.update' => 'update permission',
        'voucher' => 'Promo Code',
        'bulk-product-import' => 'bulk product import',
        'store' => 'create',
        'bulk-product-export' => 'bulk product export',
        'gallery' => 'gallery import',
        'status.change' => 'change status',
        'payment.status.toggle' => 'payment update',
        'assign.rider' => 'assign rider',
        'generale-setting' => 'general setting',
        'business-setting' => 'business setting',
        'socialLink' => 'social link',
        'legalPage' => 'legal page',
        'themeColor' => 'theme color',
        'deliveryCharge' => 'delivery charge',
        'pusher' => 'pusher config',
        'mailConfig' => 'mail config',
        'paymentGateway' => 'payment gateway',
        'sms-gateway' => 'sms gateway',
        'contactUs' => 'contact us',
        'firebase' => 'firebase config',
        'change-password' => 'change password',
        'assign.order' => 'assign order',
        'customer' => 'customer',
        'customerNotification' => 'customer notification',
        'language' => 'Language Settings',
        'ticketIssueType' => 'ticket issue type',
        'supportTicket' => 'support ticket',
        'updateStatus' => 'status update',
        'chatToggle' => 'chat enable/disable',
        'support' => 'contact messages',
        'role' => 'roles & permissions',
        'socialAuth' => 'social login',
        'productStore' => 'product store',
        'productRemove' => 'product remove',
        'product.edit' => 'product edit',
        'googleReCaptcha' => 'google reCAPTCHA',
        'vatTax' => 'VAT & Tax',
        'flashSale' => 'flash sale',
        'order.update' => 'Order base tax update',
        'aiPrompt' => 'OpenAI',
        'generate.AI.data' => 'generate AI data',
        'unisharp.lfm' => 'File Manager',
        'customer.chat' => 'Customer Chat',
        'allProduct.stockSummary'=>'Product Stock Summary'
    ],
];
